PROGRAM DisplayInterface
VAR_EXTERNAL
DisplayAddress : usint;
DisplayTimeSchedule1 : int;
DisplayTimeSchedule2 : int;
DisplayTimeSchedule3 : int;
DisplayTimeSchedule4 : int;
DisplayTimeSchedule5 : int;
DisplayTemperature : real;
DisplayTamper : int;
DisplayPoint2 : real;
DisplayPoint3 : real;
DisplayPoint6 : real;
END_VAR
VAR_GLOBAL
END_VAR
VAR
Result : int;
DisplayModbusMaster : ModbusRegistersFB;
SaveRegistersTimer : int := 5001;
NewValue : real;
FirstRun : int := 1;
dwTemp : dword;
diTemp : dint;
END_VAR

(* POINT2:  *)
(* This point is a setpoint. If value is changed it is saved to registers and SaveRegistersTimer is reinitialised *)
NewValue := GetDisplayPointValueF(PointNumber:=2, SlaveAddress:=DisplayAddress, OldValue:=DisplayPoint2);
if (NewValue <> DisplayPoint2) then
    SaveRegistersTimer := 0;
    diTemp := REAL_TO_DINT(NewValue*1000.0);
    dwTemp := DINT_TO_DWORD(diTemp);
    Result := SetLongRegisterF(900, dwTemp);
end_if;
DisplayPoint2 := NewValue;
if (FirstRun = 1) then
    (* At first run point value is loaded from registers *)
    dwTemp := GetLongRegisterF(900);
    diTemp := DWORD_TO_DINT(dwTemp);
    DisplayPoint2 := DINT_TO_REAL(diTemp) / 1000.0;
end_if;
Result := SetDisplayPointF(PointNumber:=2, PointType:=0, PointUnit:=0, SlaveAddress:=DisplayAddress, PointValue:=DisplayPoint2 );

(* POINT3:  *)
(* This point is a setpoint. If value is changed it is saved to registers and SaveRegistersTimer is reinitialised *)
NewValue := GetDisplayPointValueF(PointNumber:=3, SlaveAddress:=DisplayAddress, OldValue:=DisplayPoint3);
if (NewValue <> DisplayPoint3) then
    SaveRegistersTimer := 0;
    diTemp := REAL_TO_DINT(NewValue*1000.0);
    dwTemp := DINT_TO_DWORD(diTemp);
    Result := SetLongRegisterF(902, dwTemp);
end_if;
DisplayPoint3 := NewValue;
if (FirstRun = 1) then
    (* At first run point value is loaded from registers *)
    dwTemp := GetLongRegisterF(902);
    diTemp := DWORD_TO_DINT(dwTemp);
    DisplayPoint3 := DINT_TO_REAL(diTemp) / 1000.0;
end_if;
Result := SetDisplayPointF(PointNumber:=3, PointType:=0, PointUnit:=0, SlaveAddress:=DisplayAddress, PointValue:=DisplayPoint3 );

(* POINT6:  *)
(* This point is a setpoint. If value is changed it is saved to registers and SaveRegistersTimer is reinitialised *)
NewValue := GetDisplayPointValueF(PointNumber:=6, SlaveAddress:=DisplayAddress, OldValue:=DisplayPoint6);
if (NewValue <> DisplayPoint6) then
    SaveRegistersTimer := 0;
    diTemp := REAL_TO_DINT(NewValue*1000.0);
    dwTemp := DINT_TO_DWORD(diTemp);
    Result := SetLongRegisterF(904, dwTemp);
end_if;
DisplayPoint6 := NewValue;
if (FirstRun = 1) then
    (* At first run point value is loaded from registers *)
    dwTemp := GetLongRegisterF(904);
    diTemp := DWORD_TO_DINT(dwTemp);
    DisplayPoint6 := DINT_TO_REAL(diTemp) / 1000.0;
end_if;
Result := SetDisplayPointF(PointNumber:=6, PointType:=0, PointUnit:=0, SlaveAddress:=DisplayAddress, PointValue:=DisplayPoint6 );

(* Read some measurements from the display *)
DisplayModbusMaster(send:=0, SlaveAddress:=DisplayAddress, StartRegister:=3000, RegisterCount:=63, RegisterType:=3, TimeOut:=200, PollInterval:=2000);
DisplayTemperature := INT_TO_REAL(WORD_TO_INT(DisplayModbusMaster.Reg0))/10.0;
DisplayTamper := BOOL_TO_INT(DisplayModbusMaster.Reg6 = 1023);
DisplayTimeSchedule1 := WORD_TO_INT(DisplayModbusMaster.Reg7);
DisplayTimeSchedule2 := WORD_TO_INT(DisplayModbusMaster.Reg8);
DisplayTimeSchedule3 := WORD_TO_INT(DisplayModbusMaster.Reg9);
DisplayTimeSchedule4 := WORD_TO_INT(DisplayModbusMaster.Reg10);
DisplayTimeSchedule5 := WORD_TO_INT(DisplayModbusMaster.Reg11);
if (DisplayTamper = 1) then
    DisplayModbusMaster.Reg62 := 0;
    DisplayModbusMaster(send:=1);
end_if;

(* Save registers if any of the setpoints is changed *)
(* 50 loop delay is to let user do all the settings before saving *)
if (SaveRegistersTimer < 50) then
    SaveRegistersTimer := SaveRegistersTimer + 1;
elsif (SaveRegistersTimer = 50) then
    SaveRegistersTimer := SaveRegistersTimer + 1;
    Result := SaveRegistersF(1);
end_if;

FirstRun:=0;
END_PROGRAM
